/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IPropertyFactory;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandManager;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.bstats.velocity.Metrics;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.interfaces.ISRProxyPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.shared.utils.log.Slf4jLoggerImpl;
import net.skinsrestorer.velocity.SkinApplierVelocity;
import net.skinsrestorer.velocity.command.GUICommand;
import net.skinsrestorer.velocity.command.SkinCommand;
import net.skinsrestorer.velocity.command.SrCommand;
import net.skinsrestorer.velocity.listener.GameProfileRequest;
import net.skinsrestorer.velocity.utils.VelocityProperty;
import net.skinsrestorer.velocity.utils.WrapperVelocity;
import org.slf4j.Logger;

@Plugin(id="skinsrestorer", name="SkinsRestorer", version="14.2.3", description="Ability to restore/change skins on servers! (Offline and Online Mode)", url="https://skinsrestorer.net/", authors={"knat", "AlexProgrammerDE", "Blackfire62", "McLive"})
public class SkinsRestorer
implements ISRProxyPlugin {
    private final ProxyServer proxy;
    private final Metrics.Factory metricsFactory;
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final Path dataFolderPath;
    private final SRLogger srLogger;
    private final MojangAPI mojangAPI;
    private final SkinStorage skinStorage;
    private final SkinsRestorerAPI skinsRestorerAPI;
    private final MineSkinAPI mineSkinAPI;
    private final SkinApplierVelocity skinApplierVelocity;
    private final SkinCommand skinCommand;
    private UpdateChecker updateChecker;
    private CommandManager<?, ?, ?, ?, ?, ?> manager;
    @Inject
    private PluginContainer container;

    @Inject
    public SkinsRestorer(ProxyServer proxy, Metrics.Factory metricsFactory, @DataDirectory Path dataFolderPath, Logger logger) {
        this.proxy = proxy;
        this.metricsFactory = metricsFactory;
        this.dataFolderPath = dataFolderPath;
        this.srLogger = new SRLogger(new Slf4jLoggerImpl(logger));
        this.mojangAPI = new MojangAPI(this.srLogger, this.metricsCounter);
        this.mineSkinAPI = new MineSkinAPI(this.srLogger, this.metricsCounter);
        this.skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
        this.skinsRestorerAPI = new SkinsRestorerVelocityAPI();
        this.skinApplierVelocity = new SkinApplierVelocity(this, this.srLogger);
        this.skinCommand = new SkinCommand(this);
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.srLogger.load(this.dataFolderPath);
        Path updaterDisabled = this.dataFolderPath.resolve("noupdate.txt");
        Metrics metrics = this.metricsFactory.make(this, 10606);
        metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
        if (!Files.exists(updaterDisabled, new LinkOption[0])) {
            this.updateChecker = new UpdateCheckerGitHub(2124, this.getVersion(), this.srLogger, "SkinsRestorerUpdater/Velocity");
            this.checkUpdate(true);
            Random rn = new Random();
            int delayInt = 60 + rn.nextInt(181);
            this.proxy.getScheduler().buildTask((Object)this, this::checkUpdate).repeat((long)delayInt, TimeUnit.MINUTES).delay((long)delayInt, TimeUnit.MINUTES).schedule();
        } else {
            this.srLogger.info("Updater Disabled");
        }
        Config.load(this.dataFolderPath, this.getResource("config.yml"), this.srLogger);
        Locale.load(this.dataFolderPath, this.srLogger);
        if (!this.initStorage()) {
            return;
        }
        this.proxy.getEventManager().register((Object)this, (Object)new GameProfileRequest(this));
        this.initCommands();
        this.srLogger.info("Enabled SkinsRestorer v" + this.getVersion());
        this.runAsync(() -> SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger));
    }

    private void initCommands() {
        this.manager = new VelocityCommandManager(this.proxy, this);
        this.prepareACF(this.manager, this.srLogger);
        this.manager.registerCommand(this.skinCommand);
        this.manager.registerCommand(new SrCommand(this));
        this.manager.registerCommand(new GUICommand(this));
    }

    private boolean initStorage() {
        if (!SharedMethods.initStorage(this.srLogger, this.skinStorage, this.dataFolderPath)) {
            return false;
        }
        this.runAsync(this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkUpdate() {
        this.checkUpdate(false);
    }

    private void checkUpdate(final boolean showUpToDate) {
        this.runAsync(() -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (showUpToDate) {
                    SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
                }
            }
        }));
    }

    @Override
    public String getVersion() {
        return this.container.getDescription().getVersion().orElse("Unknown");
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.proxy.getScheduler().buildTask((Object)this, runnable).schedule();
    }

    @Override
    public Collection<ISRPlayer> getOnlinePlayers() {
        return this.proxy.getAllPlayers().stream().map(WrapperVelocity::wrapPlayer).collect(Collectors.toList());
    }

    @Override
    public Optional<ISRProxyPlayer> getPlayer(String playerName) {
        return this.proxy.getPlayer(playerName).map(WrapperVelocity::wrapPlayer);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    @Override
    public Path getDataFolderPath() {
        return this.dataFolderPath;
    }

    @Override
    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    @Override
    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    public SkinApplierVelocity getSkinApplierVelocity() {
        return this.skinApplierVelocity;
    }

    @Override
    public SkinCommand getSkinCommand() {
        return this.skinCommand;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Override
    public CommandManager<?, ?, ?, ?, ?, ?> getManager() {
        return this.manager;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    private class SkinsRestorerVelocityAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerVelocityAPI() {
            super(SkinsRestorer.this.mojangAPI, SkinsRestorer.this.mineSkinAPI, SkinsRestorer.this.skinStorage, new WrapperFactoryVelocity(), new PropertyFactoryVelocity());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(Player.class).getUsername());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String playerName) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(playerName));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty property) {
            SkinsRestorer.this.skinApplierVelocity.applySkin(playerWrapper.get(Player.class), property);
        }
    }

    private static class PropertyFactoryVelocity
    implements IPropertyFactory {
        private PropertyFactoryVelocity() {
        }

        @Override
        public IProperty createProperty(String name, String value, String signature) {
            return new VelocityProperty(name, value, signature);
        }
    }

    private static class WrapperFactoryVelocity
    extends WrapperFactory {
        private WrapperFactoryVelocity() {
        }

        @Override
        public ISRPlayer wrapPlayer(Object playerInstance) {
            if (playerInstance instanceof Player) {
                Player player = (Player)playerInstance;
                return WrapperVelocity.wrapPlayer(player);
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

